
/*************************************************************************************************/

macro "Get distance bead center to membrane [F2] Action Tool -  Cc00 T0709G T6709e Tb709t T0f09D T5f09i T7f09s C0c0 Tbf09M Thf09b" {

/***
 * Save the distance between the labeling (bead) and the cell membrane in µm
 */

image_folder_name = getDirectory("Please select the folder containing the tomograms for bead to membrane measurement");

imagenumber = getTitle();


if (File.exists(image_folder_name + File.separator + "Distance_measurement")!=1) {
	File.makeDirectory(image_folder_name + File.separator + "Distance_measurement");
}

getPixelSize(unit, pw, ph, pd);
getLine(x1, y1, x2, y2, lineWidth);

distance = sqrt(pow(x2-x1,2)+pow(y2-y1,2))*pw;
 // name file where data is saved
segment_path = image_folder_name + File.separator + "Distance_measurement" + File.separator +  imagenumber + "_Distance_to_membrane.txt";

if (File.exists(segment_path)!=1)
File.saveString("", segment_path); 

File.append(toString(distance)+'\r', segment_path);

}

/*************************************************************************************************/

macro "Get distance bead center to membrane [F2] -  Cc00 T0709G T6709e Tb709t T0f09D T5f09i T7f09s C0c0 Tbf09M Thf09b" {

/***
 * Save the distance between the labeling (bead) and the cell membrane in µm
 */

image_folder_name = getDirectory("Please select the folder containing the tomograms for bead to membrane measurement");

imagenumber = getTitle();


if (File.exists(image_folder_name + File.separator + "Distance_measurement")!=1) {
	File.makeDirectory(image_folder_name + File.separator + "Distance_measurement");
}

getPixelSize(unit, pw, ph, pd);
getLine(x1, y1, x2, y2, lineWidth);

distance = sqrt(pow(x2-x1,2)+pow(y2-y1,2))*pw;
 // name file where data is saved
segment_path = image_folder_name + File.separator + "Distance_measurement" + File.separator +  imagenumber + "_Distance_to_membrane.txt";

if (File.exists(segment_path)!=1)
File.saveString("", segment_path); 

File.append(toString(distance)+'\r', segment_path);

}

/*************************************************************************************************/


macro "Get distance bead center to tip of TJ (bead first) Action Tool -  C0cc T0709G T6709e Tb709t T0f09D T5f09i T7f09s Cc0c Tbf09T Thf09J" {

/***
 * Save the distance between the labeling (bead) and the tip of the tight junction (in µm)
 * Requires the sequence to be oriented in apico-basal direction
 */

image_folder_name = getDirectory("Please select the folder containing the tomograms for bead to TJ measurement");

imagenumber = getTitle();


if (File.exists(image_folder_name + File.separator + "Distance_measurement")!=1) {
	File.makeDirectory(image_folder_name + File.separator + "Distance_measurement");
}

getPixelSize(unit, pw, ph, pd);
getLine(x1, y1, x2, y2, lineWidth);

distance = sqrt(pow(x2-x1,2)+pow(y2-y1,2))*pw;
 // name file where data is saved
segment_path = image_folder_name + File.separator + "Distance_measurement" + File.separator +  imagenumber + "_Distance_to_TJ.txt";

if (File.exists(segment_path)!=1)
File.saveString("", segment_path); 

File.append(toString(distance)+'\t'+toString(x2-x1)+'\t'+toString(y2-y1)+'\r', segment_path);

}
/*************************************************************************************************/


macro "Get distance bead center to tip of TJ (bead first) [F4] -  C0cc T0709G T6709e Tb709t T0f09D T5f09i T7f09s Cc0c Tbf09T Thf09J" {

/***
 * Save the distance between the labeling (bead) and the tip of the tight junction (in µm)
 * Requires the sequence to be oriented in apico-basal direction
 */

image_folder_name = getDirectory("Please select the folder containing the tomograms for bead to TJ measurement");

imagenumber = getTitle();


if (File.exists(image_folder_name + File.separator + "Distance_measurement")!=1) {
	File.makeDirectory(image_folder_name + File.separator + "Distance_measurement");
}

getPixelSize(unit, pw, ph, pd);
getLine(x1, y1, x2, y2, lineWidth);

distance = sqrt(pow(x2-x1,2)+pow(y2-y1,2))*pw;
 // name file where data is saved
segment_path = image_folder_name + File.separator + "Distance_measurement" + File.separator +  imagenumber + "_Distance_to_TJ.txt";

if (File.exists(segment_path)!=1)
File.saveString("", segment_path); 

File.append(toString(distance)+'\t'+toString(x2-x1)+'\t'+toString(y2-y1)+'\r', segment_path);

}
/*************************************************************************************************/

macro "Average results dist membrane Action Tool -  C66a T0709R T5709e Ta709s Tc709u Tg709l" {

Results_folder = getDirectory("Please select the folder containing your distance to membrane results");
fileList = getFileList(Results_folder);  
distance_to_membrane = newArray("");


for(i=0; i<fileList.length; i++){

//select each file with first color results
	if(indexOf(fileList[i], "Distance_to_membrane")>-1)
	{
//Open the current file
	filecolor = File.openAsString(Results_folder + File.separator + fileList[i]);
//evaluate file size
	rows=split(filecolor, "\n"); 		
	for(m=0; m<rows.length; m++){
	distance_to_membrane = Array.concat(distance_to_membrane,parseFloat(rows[m]));}
 		}
 		}

Array.print(distance_to_membrane);
//Save all results with first column first color, second column second color

File.saveString("", Results_folder + File.separator + "Results_distance_to_membrane.txt"); 

   for (k=0; k<lengthOf(distance_to_membrane); k++)
	{File.append(distance_to_membrane[k]+"\r",Results_folder + File.separator + "Results_distance_to_membrane.txt");}
	
}
/*************************************************************************************************/

macro "Average results TJ Action Tool -  C66a T0709R T5709e Ta709s Tc709u Tg709l T0f09T T5f09J" {

Results_folder = getDirectory("Please select the folder containing your distance to TJ results");
fileList = getFileList(Results_folder);  
distance_to_membrane = newArray("");


for(i=0; i<fileList.length; i++){

//select each file with first color results
	if(indexOf(fileList[i], "Distance_to_TJ")>-1)
	{
//Open the current file
	filecolor = File.openAsString(Results_folder + File.separator + fileList[i]);
//evaluate file size
	rows=split(filecolor, "\n"); 		
	for(m=0; m<rows.length; m++){
	distance_to_membrane = Array.concat(distance_to_membrane,parseFloat(rows[m]));}
 		}
 		}

Array.print(distance_to_membrane);
//Save all results with first column first color, second column second color

File.saveString("", Results_folder + File.separator + "Results_distance_to_TJ.txt"); 

   for (k=0; k<lengthOf(distance_to_membrane); k++)
	{File.append(distance_to_membrane[k]+"\r",Results_folder + File.separator + "Results_distance_to_TJ.txt");}
	
}


/*************************************************************************************************/

macro "Help Action Tool -  C0cc T0709H T6709e Tb709l T0f09p" {
showMessage("Use for TJ", "first reorient the stack to get planar surface horizontal and apical on top. Then click center of bead then top of TJ")
}
}
